
CREATE OR REPLACE FUNCTION CREATETABLE() 
RETURNS VOID AS 
$BODY$ 
DECLARE

	MSGFINAL TEXT := 'FOI CRIADA';
	
BEGIN 
	IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS  WHERE TABLE_NAME= 'est_orc_glb_medico') THEN 

	CREATE TABLE est_orc_glb_medico(
    cd_emp integer NOT NULL,
    cd_filial integer NOT NULL,
    cd_prod integer NOT NULL,
    nr_orc integer NOT NULL,
    dt_cad date NOT NULL DEFAULT ('now'::text)::date,
    cd_medico_rec integer NOT NULL,
    cd_vend integer NOT NULL,
    qt_prod integer NOT NULL,
    flag_consolidado integer DEFAULT 0,
    nr_receita bigint,
    dt_receita timestamp without time zone,
    cd_receita integer,
    tp_capt_receita character(1),
    nm_comprador character varying(100),
    idade integer,
    nm_paciente character varying(100),
    receita_tipo integer,
    cid integer,
    uf character varying(4),
    nr_doc_cli character varying,
    tipo_documento integer,
    sexo integer,
    tp_doc_exp integer,
    cd_it integer NOT NULL DEFAULT 1,
    tp_idade integer DEFAULT 0,
    id_receita integer NOT NULL DEFAULT 1,
    end_comprador character varying(300),
    numero_comprador character varying(50),
    cep_comprador character varying(50),
    bairro_comprador character varying(50),
    cd_cid_comprador integer,
    tel_comprador character varying(50),
    CONSTRAINT est_orc_glb_medico_pkey UNIQUE (cd_emp, cd_filial, cd_prod, nr_orc, dt_cad, cd_it)
);
	ELSE    
		MSGFINAL := 'A TABELA JÁ EXISTE';
	END IF;

	RAISE NOTICE 'TABELA est_orc_glb_medico %', MSGFINAL::VARCHAR;

END; 
-- FIM BLOCO PRINCIPAL 
$BODY$ 
LANGUAGE PLPGSQL VOLATILE 
  COST 100; 
ALTER FUNCTION CREATETABLE() OWNER TO POSTGRES;
SELECT CREATETABLE(); 
DROP FUNCTION CREATETABLE();